#ifndef __CModulatedSlider__
#define __CModulatedSlider__

#include "CRangeSlider.hpp"
using Exponent::GUI::Controls::CRangeSlider;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CModulatedSlider CModulatedSlider.hpp
			 * @brief Represents a modulated slider.
			 *
			 * @date 18/09/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CModulatedSlider.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CModulatedSlider : public CRangeSlider
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 * @param listener The action listener
				 */
				CModulatedSlider(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener = NULL);

				/**
				 * Destruction
				 */
				virtual ~CModulatedSlider();

//	===========================================================================

				/**
				 * Draw the control
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

//	===========================================================================

				/**
				 * Set the modulation value
				 * @param value The modulated value of the slider
				 */
				void setModulationValue(const double value);

//	===========================================================================

			protected:

//	===========================================================================

				double m_modulatedValue;			/**< The modulated value */
				CRect m_modulatedSlider;			/**< The modulated position */

			};
		}
	}
}
#endif	// End of CModulatedSlider.hpp